//Analog Low Pass Filter to Band Stop Filter Conversion
//OS:Windows 10
//Scilab 6.0.0

clear ;
clc ;
close ;

fc1 = input("Enter Analog lower cutoff freq. in Hz=")
fc2 = input("Enter Analog higher cutoff freq. in Hz=")
fs = input("Enter Analog sampling freq. in Hz=")
M = input("Enter order of filter =")
w1 = (2*%pi)*(fc1/fs);
w2 = (2*%pi)*(fc2/fs);
disp(w1,'Digital lower cutoff frequency in radians.cycles/samples');
disp(w2,'Digital higher cutoff frequency in radians.cycles/samples');
wc1 = w1/%pi;
wc2 = w2/%pi;
disp(wc1,'Normalized digital lower cutoff frequency in cycles/samples');
disp(wc2,'Normalized digital higher cutoff frequency in cycles/samples');
[wft1,wfm1,fr1]=wfir('lp',M+1,[wc1/2,0],'re',[0,0]);
disp(wft1,'Impulse Response of LPF FIR Filter:h[n]=');

//Plotting the Magnitude Response of LPF FIR Filter
figure
subplot(2,1,1)
plot(2*fr1,wfm1)
xlabel('Normalized Digital Frequency w--->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR LPF')
xgrid(1)
subplot(2,1,2)
plot(fr1*fs,wfm1)
xlabel('Analog Frequency in Hz f --->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR LPF')
xgrid(1)

[wft,wfm,fr]=wfir('sb',M+1,[wc1/2,wc2/2],'re',[0,0]);
disp(wft,'Impulse Response of BSF FIR Filter:h[n]=');

//Plotting the Magnitude Response of HPF FIR Filter
figure
subplot(2,1,1)
plot(2*fr,wfm)
xlabel('Normalized Digital Frequency w--->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR BSF')
xgrid(1)
subplot(2,1,2)
plot(fr*fs,wfm)
xlabel('Analog Frequency in Hz f --->')
ylabel('Magnitude |H(w)|=')
title('Magnitude Response of FIR BSF')
xgrid(1)


//Example Input
//Enter Analog lower cutoff freq. in Hz=250
//Enter Analog higher cutoff freq. in Hz=600
//Enter Analog sampling freq. in Hz=2000
//Enter order of filter =4
//Digital lower cutoff frequency in radians 
// .cycles/samples                          
//   0.7853982

// Digital higher cutoff frequency in radian 
// s.cycles/samples                         
//   1.8849556

// Normalized digital lower cutoff frequency 
//  in cycles/samples                       
//   0.25

// Normalized digital higher cutoff frequenc 
// y in cycles/samples                      
//   0.6
// Impulse Response of LPF FIR Filter:h[n]=
//         column 1 to 3
//   0.1591549   0.2250791   0.25
//         column 4 to 5
//   0.2250791   0.1591549

// Impulse Response of BSF FIR Filter:h[n]=
//         column 1 to 3
//   0.2527039  -0.0776516   0.65
//         column 4 to 5
//  -0.0776516   0.2527039
